<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateUsersTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'           => [
                'type'           => 'INT',
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'name'         => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'email'        => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => false,
            ],
            'password'     => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => false,
            ],
            'role_id'            => ['type'=>'INT', 'null'=>true],
            'permissions'  => [
                'type'       => 'TEXT',
                'null'       => true,
            ],
            'reset_token'       => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'reset_expires_at'  => [
                'type'       => 'DATETIME',
                'null'       => true,
            ],
            'created_at'   => [
                'type'       => 'DATETIME',
                'null'       => true,
            ],
            'updated_at'   => [
                'type'       => 'DATETIME',
                'null'       => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addUniqueKey('email');
        $this->forge->addForeignKey('role_id','roles','id','SET NULL','CASCADE');
        $this->forge->createTable('users');
    }

    public function down()
    {
        $this->forge->dropTable('users');
    }
}

