<?php

namespace App\Controllers;

use CodeIgniter\Controller;

class ProfileController extends BaseController
{
    public function index()
    {
        $session = session();
        if (!$session->get('isLoggedIn')) {
            return redirect()->to('/login');
        }

        $data = $this->data;
        $data['user'] = $session->get();
        return view('profile/index', $data);
    }

    public function update()
    {
        $session = session();
        if (!$session->get('isLoggedIn')) {
            return redirect()->to('/login');
        }

        $data = $this->request->getPost();

        // Validate input
        $validation = \Config\Services::validation();
        $validation->setRules([
            'name' => 'required|min_length[3]|max_length[255]',
            'email' => 'required|valid_email',
        ]);

        if (!$validation->withRequest($this->request)->run()) {
            return redirect()->back()->withInput()->with('errors', $validation->getErrors());
        }

        // Update user data
        $userModel = new \App\Models\UserModel();
        $userId = $session->get('id');

        $updateData = [
            'name' => $data['name'],
            'email' => $data['email'],
        ];

        // Handle password change
        if (!empty($data['password'])) {
            $updateData['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
        }

        try {
            $userModel->update($userId, $updateData);

            // Update session data
            $session->set([
                'name' => $data['name'],
                'email' => $data['email'],
            ]);

            return redirect()->to('/profile')->with('success', 'Profil berhasil diperbarui.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Gagal memperbarui profil: ' . $e->getMessage());
        }
    }
}
