<?php

namespace App\Controllers;

use App\Models\MenuModel;
use App\Models\RoleModel;
use App\Models\LogAktivitasModel;
use CodeIgniter\Controller;

class Dashboard extends BaseController
{
    protected $menuModel;
    protected $roleModel;
    protected $session;
    protected $logAktivitas;

    public function __construct()
    {
        helper(['url']);
        $this->menuModel = new MenuModel();
        $this->roleModel = new RoleModel();
        $this->session = session();
        //   $this->logAktivitas = new LogAktivitas();
    }

    public function index()
    {
        $session = session();
        if (!$session->get('isLoggedIn')) {
            return redirect()->to('/login');
        }

        $userPermissions = $session->get('permissions') ?? [];

        if (!is_array($userPermissions)) {
            $userPermissions = json_decode($userPermissions, true) ?? [];
        }
        $menuModel = new MenuModel();
        $menus = $menuModel->getMenusByPermissions($userPermissions);

        // Check if user is superadmin (role_id = 1)
        $userRoleId = $session->get('role_id');
        $recentLogs = null;

        if ($userRoleId == 1) { // superadmin
            // Get recent log activities only for superadmin
            $logAktivitasModel = new LogAktivitasModel();
            $recentLogs = $logAktivitasModel->getRecentLogs(5);
        }

        $data = [
            'title' => 'Dashboard',
            'user'  => $session->get('name'),
            'menus' => $menus,
            'recentLogs' => $recentLogs,
            'isSuperAdmin' => ($userRoleId == 1)
        ];
        echo view('dashboard', $data);
    }
}
