<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\MenuModel;
use App\Models\RoleModel;
use App\Models\UserModel;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

abstract class BaseController extends Controller
{
    protected $data = [];
    protected $menuModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        helper(['permission', 'url']);

        $session = session();
        $this->menuModel = new MenuModel();

        if ($session->get('isLoggedIn')) {
            $permissions = $session->get('permissions') ?? [];
            if (!is_array($permissions)) {
                $permissions = json_decode($permissions, true) ?? [];
            }
            $menus = $this->menuModel->getMenusByPermissions($permissions);

            $this->data['menus'] = $menus;
            $this->data['user']  = $session->get('name');
        }
    }

    protected function checkPermission($requiredPermission)
    {
        $session = session();
        if (!$session->get('isLoggedIn')) {
            $session->setFlashdata('error', 'Silakan login terlebih dahulu');
            return redirect()->to('/login');
        }

        $permissions = $session->get('permissions') ?? [];
        if (!in_array($requiredPermission, $permissions)) {
            $session->setFlashdata('error', "Anda tidak memiliki akses untuk: $requiredPermission");
            return redirect()->to('/dashboard');
        }

        return true;
    }
}
