<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Auth');
$routes->setDefaultMethod('login');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// Authentication
$routes->get('/', 'Auth::login');
$routes->get('login', 'Auth::login');
$routes->post('login', 'Auth::loginPost');
$routes->get('register', 'Auth::register');
$routes->post('register', 'Auth::registerPost');
$routes->get('logout', 'Auth::logout');
$routes->get('forgot-password', 'Auth::forgotPassword');
$routes->post('forgot-password', 'Auth::forgotPasswordPost');
$routes->get('reset-password/(:segment)', 'Auth::resetPassword/$1');
$routes->post('reset-password/(:segment)', 'Auth::resetPasswordPost/$1');

// Profile routes
$routes->get('profile', 'ProfileController::index');
$routes->post('profile/update', 'ProfileController::update');

//code generator
$routes->get('codegenerator', 'CodeGeneratorController::index');
$routes->post('codegenerator/generate', 'CodeGeneratorController::generate');

// system config
$routes->get('/system-config', 'System_configController::index');
$routes->get('/system_config/create', 'System_configController::create');
$routes->get('/system-config/edit', 'System_configController::edit');
$routes->post('/system-config/update', 'System_configController::update');

// email config
$routes->get('email-config', 'EmailConfigController::index');
$routes->get('email-config/edit/(:num)', 'EmailConfigController::edit/$1');
$routes->post('email-config/update/(:num)', 'EmailConfigController::update/$1');
$routes->post('email-config/test', 'EmailConfigController::testEmail');

// role manajemen
$routes->get('roles', 'RoleController::index');
$routes->get('roles/create', 'RoleController::create');
$routes->get('roles/show/(:num)', 'RoleController::show/$1');
$routes->get('roles/edit/(:num)', 'RoleController::edit/$1');
$routes->post('roles/store', 'RoleController::store');
$routes->put('roles/update/(:num)', 'RoleController::update/$1');
$routes->post('roles/update/(:num)', 'RoleController::update/$1');
$routes->post('roles/delete/(:num)', 'RoleController::delete/$1');

// role manajemenDosen
$routes->get('dosen', 'DosenController::index');
$routes->get('dosen/create', 'DosenController::create');
$routes->get('dosen/show/(:num)', 'DosenController::show/$1');
$routes->get('dosen/edit/(:num)', 'DosenController::edit/$1');
$routes->post('dosen/store', 'DosenController::store');
$routes->put('dosen/update/(:num)', 'DosenController::update/$1');
$routes->post('dosen/update/(:num)', 'DosenController::update/$1');
$routes->post('dosen/delete/(:num)', 'DosenController::delete/$1');

// role manajemenFakultas
$routes->get('fakultas', 'FakultaController::index');
$routes->get('fakultas/create', 'FakultaController::create');
$routes->get('fakultas/show/(:num)', 'FakultaController::show/$1');
$routes->get('fakultas/edit/(:num)', 'FakultaController::edit/$1');
$routes->post('fakultas/store', 'FakultaController::store');
$routes->put('fakultas/update/(:num)', 'FakultaController::update/$1');
$routes->post('fakultas/update/(:num)', 'FakultaController::update/$1');
$routes->post('fakultas/delete/(:num)', 'FakultaController::delete/$1');

// Auditor Routes
$routes->get('auditor', 'AuditorController::index');        // List
$routes->get('auditor/create', 'AuditorController::create'); // Form Tambah
$routes->post('auditor/store', 'AuditorController::store');  // Simpan Data
$routes->get('auditor/edit/(:num)', 'AuditorController::edit/$1');  // Form Edit
$routes->post('auditor/update/(:num)', 'AuditorController::update/$1'); // Update Data
$routes->post('auditor/delete/(:num)', 'AuditorController::delete/$1'); // Hapus Data
$routes->get('auditor/show/(:num)', 'AuditorController::show/$1');     // Detail (opsional)

//Routes Berkas
$routes->get('berkas', 'BerkaController::index');
$routes->get('berkas/create', 'BerkaController::create');
$routes->post('berkas/store', 'BerkaController::store');
$routes->get('berkas/edit/(:num)', 'BerkaController::edit/$1');
$routes->post('berkas/update/(:num)', 'BerkaController::update/$1');
$routes->get('berkas/show/(:num)', 'BerkaController::show/$1');
$routes->post('berkas/delete/(:num)', 'BerkaController::delete/$1');
$routes->get('berkas/view/(:segment)', 'BerkaController::show/$1');



// LEMBAGA AKREDITASI ROUTES
$routes->get('/lemb_akreditasi', 'Lemb_akreditasiController::index');
$routes->get('/lemb_akreditasi/create', 'Lemb_akreditasiController::create');
$routes->post('/lemb_akreditasi/store', 'Lemb_akreditasiController::store');
$routes->get('/lemb_akreditasi/edit/(:any)', 'Lemb_akreditasiController::edit/$1');
$routes->post('/lemb_akreditasi/update/(:any)', 'Lemb_akreditasiController::update/$1');
$routes->post('/lemb_akreditasi/delete/(:any)', 'Lemb_akreditasiController::delete/$1');
$routes->get('/lemb_akreditasi/show/(:any)', 'Lemb_akreditasiController::show/$1');

//Standar Lembaga
$routes->get('menus/standar_lembaga_akreditasi', 'Standar_lembaga_akreditasiController::index');
$routes->get('standar_lembaga_akreditasi', 'Standar_lembaga_akreditasiController::index');
$routes->get('standar_lembaga_akreditasi/create', 'Standar_lembaga_akreditasiController::create');
$routes->get('standar_lembaga_akreditasi/show/(:num)', 'Standar_lembaga_akreditasiController::show/$1');
$routes->get('standar_lembaga_akreditasi/edit/(:num)', 'Standar_lembaga_akreditasiController::edit/$1');
$routes->post('standar_lembaga_akreditasi/store', 'Standar_lembaga_akreditasiController::store');
$routes->post('standar_lembaga_akreditasi/update/(:num)', 'Standar_lembaga_akreditasiController::update/$1');
$routes->post('standar_lembaga_akreditasi/delete/(:num)', 'Standar_lembaga_akreditasiController::delete/$1');


// Routes Periode Audit
$routes->get('periode_audit', 'Periode_auditController::index');
$routes->get('periode_audit/create', 'Periode_auditController::create');
$routes->get('periode_audit/show/(:num)', 'Periode_auditController::show/$1');
$routes->get('periode_audit/edit/(:num)', 'Periode_auditController::edit/$1');
$routes->post('periode_audit/store', 'Periode_auditController::store');
$routes->post('periode_audit/update/(:num)', 'Periode_auditController::update/$1');
$routes->put('periode_audit/update/(:num)', 'Periode_auditController::update/$1');
$routes->post('periode_audit/delete/(:num)', 'Periode_auditController::delete/$1');

// Routes Tindakan Koreksi
$routes->get('tindakan_koreksi', 'Tindakan_koreksiController::index');
$routes->get('tindakan_koreksi/create', 'Tindakan_koreksiController::create');
$routes->get('tindakan_koreksi/show/(:num)', 'Tindakan_koreksiController::show/$1');
$routes->get('tindakan_koreksi/edit/(:num)', 'Tindakan_koreksiController::edit/$1');
$routes->post('tindakan_koreksi/store', 'Tindakan_koreksiController::store');
$routes->put('tindakan_koreksi/update/(:num)', 'Tindakan_koreksiController::update/$1');
$routes->post('tindakan_koreksi/update/(:num)', 'Tindakan_koreksiController::update/$1');
$routes->post('tindakan_koreksi/delete/(:num)', 'Tindakan_koreksiController::delete/$1');


// Routes Unit Kerja
$routes->get('unit_kerja', 'Unit_kerjaController::index');
$routes->get('unit_kerja/create', 'Unit_kerjaController::create');
$routes->get('unit_kerja/show/(:num)', 'Unit_kerjaController::show/$1');
$routes->get('unit_kerja/edit/(:num)', 'Unit_kerjaController::edit/$1');
$routes->post('unit_kerja/store', 'Unit_kerjaController::store');
$routes->post('unit_kerja/update/(:num)', 'Unit_kerjaController::update/$1');
$routes->post('unit_kerja/delete/(:num)', 'Unit_kerjaController::delete/$1');

// Routes Daftar Tilik
$routes->get('daftar_tilik', 'Daftar_tilikController::index');
$routes->get('daftar_tilik/create', 'Daftar_tilikController::create');
$routes->get('daftar_tilik/show/(:num)', 'Daftar_tilikController::show/$1');
$routes->get('daftar_tilik/edit/(:num)', 'Daftar_tilikController::edit/$1');
$routes->post('daftar_tilik/store', 'Daftar_tilikController::store');
$routes->post('daftar_tilik/update/(:num)', 'Daftar_tilikController::update/$1');
$routes->post('daftar_tilik/delete/(:num)', 'Daftar_tilikController::delete/$1');

//Routes Prodi
$routes->get('prodi', 'ProdiController::index');
$routes->get('prodi/create', 'ProdiController::create');
$routes->get('prodi/show/(:num)', 'ProdiController::show/$1');
$routes->get('prodi/edit/(:num)', 'ProdiController::edit/$1');
$routes->post('prodi/store', 'ProdiController::store');
$routes->put('prodi/update/(:num)', 'ProdiController::update/$1');
$routes->post('prodi/update/(:num)', 'ProdiController::update/$1');
$routes->post('prodi/delete/(:num)', 'ProdiController::delete/$1');

// Routes Capaian Kinerja Prodi
$routes->get('capaian_kinerja_prodi', 'Capaian_kinerja_prodiController::index');
$routes->get('capaian_kinerja_prodi/create', 'Capaian_kinerja_prodiController::create');
$routes->get('capaian_kinerja_prodi/show/(:num)', 'Capaian_kinerja_prodiController::show/$1');
$routes->get('capaian_kinerja_prodi/edit/(:num)', 'Capaian_kinerja_prodiController::edit/$1');
$routes->post('capaian_kinerja_prodi/store', 'Capaian_kinerja_prodiController::store');
$routes->post('capaian_kinerja_prodi/update/(:num)', 'Capaian_kinerja_prodiController::update/$1');
$routes->post('capaian_kinerja_prodi/delete/(:num)', 'Capaian_kinerja_prodiController::delete/$1');

// Routes Evaluasi Diri
$routes->get('evaluasi_diri', 'Evaluasi_diriController::index');
$routes->get('evaluasi_diri/create', 'Evaluasi_diriController::create');
$routes->get('evaluasi_diri/show/(:num)', 'Evaluasi_diriController::show/$1');
$routes->get('evaluasi_diri/edit/(:num)', 'Evaluasi_diriController::edit/$1');
$routes->post('evaluasi_diri/store', 'Evaluasi_diriController::store');
$routes->put('evaluasi_diri/update/(:num)', 'Evaluasi_diriController::update/$1');
$routes->post('evaluasi_diri/update/(:num)', 'Evaluasi_diriController::update/$1');
$routes->post('evaluasi_diri/delete/(:num)', 'Evaluasi_diriController::delete/$1');

// Routes Matrix Penilaian
$routes->get('matrix_penilaian', 'Matrix_penilaianController::index');
$routes->get('matrix_penilaian/create', 'Matrix_penilaianController::create');
$routes->get('matrix_penilaian/show/(:num)', 'Matrix_penilaianController::show/$1');
$routes->get('matrix_penilaian/edit/(:num)', 'Matrix_penilaianController::edit/$1');
$routes->post('matrix_penilaian/store', 'Matrix_penilaianController::store');
$routes->put('matrix_penilaian/update/(:num)', 'Matrix_penilaianController::update/$1');
$routes->post('matrix_penilaian/update/(:num)', 'Matrix_penilaianController::update/$1');
$routes->post('matrix_penilaian/delete/(:num)', 'Matrix_penilaianController::delete/$1');

// Routes Peluang Peningkatan
$routes->get('peluang_peningkatan', 'Peluang_peningkatanController::index');
$routes->get('peluang_peningkatan/create', 'Peluang_peningkatanController::create');
$routes->get('peluang_peningkatan/show/(:num)', 'Peluang_peningkatanController::show/$1');
$routes->get('peluang_peningkatan/edit/(:num)', 'Peluang_peningkatanController::edit/$1');
$routes->post('peluang_peningkatan/store', 'Peluang_peningkatanController::store');
$routes->post('peluang_peningkatan/update/(:num)', 'Peluang_peningkatanController::update/$1');
$routes->put('peluang_peningkatan/update/(:num)', 'Peluang_peningkatanController::update/$1');
$routes->post('peluang_peningkatan/delete/(:num)', 'Peluang_peningkatanController::delete/$1');

// Routes Penugasan Audit
$routes->get('penugasan_audit', 'Penugasan_auditController::index');
$routes->get('penugasan_audit/create', 'Penugasan_auditController::create');
$routes->get('penugasan_audit/show/(:num)', 'Penugasan_auditController::show/$1');
$routes->get('penugasan_audit/edit/(:num)', 'Penugasan_auditController::edit/$1');
$routes->post('penugasan_audit/store', 'Penugasan_auditController::store');
$routes->put('penugasan_audit/update/(:num)', 'Penugasan_auditController::update/$1');
$routes->post('penugasan_audit/update/(:num)', 'Penugasan_auditController::update/$1');
$routes->post('penugasan_audit/delete/(:num)', 'Penugasan_auditController::delete/$1');

// Routes Temuan Audit
$routes->get('temuan_audit', 'Temuan_auditController::index');
$routes->get('temuan_audit/create', 'Temuan_auditController::create');
$routes->get('temuan_audit/show/(:num)', 'Temuan_auditController::show/$1');
$routes->get('temuan_audit/edit/(:num)', 'Temuan_auditController::edit/$1');
$routes->post('temuan_audit/store', 'Temuan_auditController::store');
$routes->put('temuan_audit/update/(:num)', 'Temuan_auditController::update/$1');
$routes->post('temuan_audit/update/(:num)', 'Temuan_auditController::update/$1');
$routes->post('temuan_audit/delete/(:num)', 'Temuan_auditController::delete/$1');


// User management
$routes->group('', ['filter' => 'authfilter'], function ($routes) {
    $routes->get('dashboard', 'Dashboard::index');
    $routes->get('users', 'User::index');
    $routes->get('users/create', 'User::create');
    $routes->post('users/store', 'User::store');
    $routes->get('users/edit/(:num)', 'User::edit/$1');
    $routes->post('users/update/(:num)', 'User::update/$1');
    $routes->get('users/delete/(:num)', 'User::delete/$1');

    $routes->get('menus', 'Menu::index');
    $routes->get('menus/create', 'Menu::create');
    $routes->post('menus/store', 'Menu::store');
    $routes->get('menus/edit/(:num)', 'Menu::edit/$1');
    $routes->post('menus/update/(:num)', 'Menu::update/$1');
    $routes->get('menus/delete/(:num)', 'Menu::delete/$1');

    // Log Aktivitas routes
    $routes->get('log-aktivitas', 'LogAktivitasController::index');
    $routes->get('log-aktivitas/filter', 'LogAktivitasController::filter');
    $routes->get('log-aktivitas/show/(:num)', 'LogAktivitasController::show/$1');
    $routes->get('api/log-aktivitas', 'LogAktivitasController::api_logs');
});



/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 */

if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
